/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.Filter;
import apicore.util.Logger;
import apicore.util.Utilities;
import java.nio.ByteBuffer;

public class XorEncryptionFilter
implements Filter {
    private byte[] key = new byte[]{0};

    public XorEncryptionFilter(ConnectionNegotiationProperties connectionNegotiationProperties) {
        if (connectionNegotiationProperties != null) {
            String string = connectionNegotiationProperties.getServerUid();
            String string2 = connectionNegotiationProperties.getClientUid();
            String string3 = connectionNegotiationProperties.getServerTimestamp();
            String string4 = connectionNegotiationProperties.getClientTimestamp();
            if (string != null && string2 != null && string3 != null && string4 != null) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
                try {
                    byte[] byArray = Utilities.decodeHex(string);
                    byte[] byArray2 = Utilities.decodeHex(string2);
                    byteBuffer.put(byArray);
                    byteBuffer.put(byArray2);
                    byteBuffer.put("PTMP".getBytes());
                    byteBuffer.put(string3.getBytes());
                    byteBuffer.put(string4.getBytes());
                    this.key = new byte[byteBuffer.position()];
                    byteBuffer.flip();
                    byteBuffer.get(this.key);
                }
                catch (Throwable throwable) {
                    Logger.error("Error decoding encryption key field: " + throwable.getMessage());
                }
            } else {
                Logger.warn("Required encryption key field is empty.");
            }
        } else {
            Logger.warn("ConnectionNegotiationProperties is empty.");
        }
    }

    public byte[] in(byte[] byArray) {
        return this.xorBytes(byArray);
    }

    public byte[] out(byte[] byArray) {
        return this.xorBytes(byArray);
    }

    private byte[] xorBytes(byte[] byArray) {
        byte[] byArray2 = null;
        int n = this.key.length;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            int n2 = 0;
            for (byte by : byArray) {
                byArray2[n2] = (byte)(by ^ this.key[n2 % n]);
                ++n2;
            }
        }
        return byArray2;
    }
}

